#ifndef _CONSTANT_WIDTH_HLSL_
#define _CONSTANT_WIDTH_HLSL_  

  #include "shaders\common.hlsl"

  float2 mapFull(in float3 pos);

	float2 map(in float3 pos)
	{
	  float2 dis = float2(INF, -1);

		//float2 ns = voronoi(pos.yz);
		//return float2(0.5 - abs(pos.x) + (ns.y - ns.x) * 0.5 + (sin(pos.x * 1.5) * sin(pos.y * 1.5)) * 0.3, 3.0);

#if USE_BB_OPTIMIZATION
    [branch] if (gVisible[0])
    {
	    float co = sdCone(pos + float3(18.0, -4.0, 0.0), float3(0.866,0.5,6.0));
	    dis = opU(dis, float2(co, 1.0));
    }

    //[branch] if (gVisible[1])
    //{
	   // float tp = sdTriPrism(pos + float3(12.0, 0.0, 0.0), float2(1, 3));
	   // dis = opU(dis, float2(tp, 6.0));
    //}

    [branch] if (gVisible[2])
    {
	    float hp = sdHexPrism(pos + float3(8.0, 0.0, 0.0), float2(1, 3));
	    dis = opU(dis, float2(hp, 2.0));
    }

    [branch] if (gVisible[3])
    {
	    float c6 = sdCylinder6(pos + float3(4.0, 0.0, 0.0), float2(1.2, 3));
	    dis = opU(dis, float2(c6, 1.0));
    }

    [branch] if (gVisible[4])
    {
	    float cw3 = sdConstantWidthCylinder3(pos - float3(0.0, 0.0, 0.0), float2(2, 3));
	    dis = opU(dis, float2(cw3, 3.0));
    }

    //[branch] if (gVisible[5])
    //{
	   // float cw5 = sdConstantWidthCylinder5(pos - float3(4.0, 0.0, 0.0), float2(2, 3));
	   // dis = opU(dis, float2(cw5, 4.0));
    //}

	  //pos = opRep(pos, float3(5.0, 10.0, 5.0));

    [branch] if (gVisible[6])
    {
	    float3 pos_cw3d = pos - float3(9.0, 0.0, 0.0);
	    float t = iGlobalTime * 2.0;
	    float4 q = makeQuat(normalize(y), t);
	    pos_cw3d = rotateVector(q, pos_cw3d);
	    pos_cw3d.y *= -1;

	    float cw3d = sdConstantWidth3d(pos_cw3d, 4);
	    dis = opU(dis, float2(cw3d, 5.0));
    }

    [branch] if (gVisible[7])
    {
	    //dis = opU(dis, sdPlane(pos + float3(0.0, 3.3, 0.0)));
	    dis = opU(dis, float2(sdBox1(pos + float3(5.0, 3.3, 0.0), float3(25.0, 1.0, 7.0)), 0.0));
    }

	  return dis;
#else
    return mapFull(pos);
#endif // USE_BB_OPTIMIZATION
	}

	float2 mapFull(in float3 pos)
	{
    float2 dis = float2(INF, -1);

	  float co = sdCone(pos + float3(18.0, -4.0, 0.0), float3(0.866,0.5,6.0));
	  dis = opU(dis, float2(co, 1.0));

    //float tp = sdTriPrism(pos + float3(12.0, 0.0, 0.0), float2(1, 3));
    //dis = opU(dis, float2(tp, 6.0));

    float hp = sdHexPrism(pos + float3(8.0, 0.0, 0.0), float2(1, 3));
	  dis = opU(dis, float2(hp, 2.0));

	  float c6 = sdCylinder6(pos + float3(4.0, 0.0, 0.0), float2(1.2, 3));
	  dis = opU(dis, float2(c6, 1.0));

	  float cw3 = sdConstantWidthCylinder3(pos - float3(0.0, 0.0, 0.0), float2(2, 3));
	  dis = opU(dis, float2(cw3, 3.0));

	  //float cw5 = sdConstantWidthCylinder5(pos - float3(4.0, 0.0, 0.0), float2(2, 3));
	  //dis = opU(dis, float2(cw5, 4.0));

    float3 pos_cw3d = pos - float3(9.0, 0.0, 0.0);
	  float t = iGlobalTime * 2.0;
	  float4 q = makeQuat(normalize(y), t);
	  pos_cw3d = rotateVector(q, pos_cw3d);
	  pos_cw3d.y *= -1;

	  float cw3d = sdConstantWidth3d(pos_cw3d, 4);
	  dis = opU(dis, float2(cw3d, 5.0));

    dis = opU(dis, float2(sdBox1(pos + float3(5.0, 3.3, 0.0), float3(25.0, 1.0, 7.0)), 0.0));

    return dis;
	}

  float3 shade(in float3 pos, in float3 nor, in float3 rd, in float matID)
  {
    float3 mate = float3(0.0, 0.0, 0.0);
	
    //mate = lerp(float3(0.3,0.3,0.3)*0.8, float3(1.0,1.0,1.0)*2.0, saturate(matID - 0.5));
    //mate = lerp(mate, float3(0.1,0.0,1.0)*0.0, saturate(matID - 1.5));
    //mate = lerp(mate, float3(1.0,1.0,1.0)*0.0, saturate(matID - 2.5));

    float3 vor = float3(voronoi(pos.yz*0.02), 0.5);

    float mode = 2.0;
    float4 c = voronoi( 8.0*pos.xz*0.02, mode );
	
    float3 col = 0.5 + 0.5*sin( c.y*2.5 + float3(1.0,1.0,1.9) );
    col *= sqrt( saturate( 1.0 - c.x ) );
	  col *= saturate( 0.5 + (1.0-c.z/2.0)*0.5 );
	  col *= 0.4 + 0.6*sqrt(saturate( 4.0*c.w ));

    //float3 vor = float3(c.x, c.x, c.x);

    mate = col;//lerp(mate, col*1.0,    saturate(matID + 1.0));
    //mate = lerp(mate, float3(0.5,0.5,0.5)*1.0,    saturate(matID + 1.0));
    //mate = lerp(mate, float3(0.8,0.8,0.8)*1.0,    saturate(matID - 0.0));
    //mate = lerp(mate, float3(0.85,0.15,0.89)*1.0, saturate(matID - 1.0));
    //mate = lerp(mate, float3(0.11,0.9,0.37)*1.0,  saturate(matID - 2.0));

    mode = 0.0;
    c = voronoi( 8.0*pos.xy, mode );
	
    col = 0.5 + 0.5*sin(matID* c.y*2.5 + float3(1.0,1.0,1.9) );
    col *= sqrt(saturate( 1.0 - c.x ) );
	  col *= saturate( 0.5 + (1.0-c.z/2.0)*0.5 );
	  col *= 0.4 + 0.6*sqrt(saturate( 4.0*c.w ));

    mate = lerp(mate, col.xzy*1.0,  saturate(matID));

    mate = lerp(mate, float3(0.11,0.9,0.37),  saturate(matID - 4.0));

    //mate = lerp(mate, col.xzy*1.0,  saturate(matID - 2.0));
    //mate = lerp(mate, float3(0.2,0.34,0.95)*1.0,  saturate(matID - 3.0));
    //mate = lerp(mate, float3(0.96,0.72,0.15)*1.0, saturate(matID - 4.0));
    //mate = lerp(mate, float3(0.89,0.21,0.22)*1.0, saturate(matID - 5.0));

    // 0 = plane
    //if (matID < 0.5)
    //{
    //  //mate.xyz = float3(0.1,0.2,0.0)*0.5;
    //  mate.xyz = float3(0.3,0.3,0.3)*0.8;
    //}
    //// 1 = sphere
    //else if (matID < 1.5)
    //{
    //  //mate.xyz = float3(0.1,1.0,0.0)*0.5;
    //  mate.xyz = float3(1.0,1.0,1.0)*2.0;
    //}
    // 2 = box
    //else if (matID < 2.5)
    //{
    //  mate.xyz = float3(0.1,0.0,1.0)*0.5;
    //}
    // 3 = cross
    //else if (matID < 3.5)
    //{
    //  //mate.xyz = float3(1.0,0.0,0.0)*0.5;
    //  mate.xyz = float3(1.0,1.0,1.0)*0.5;
    //}
    //// 4 = bridge
    //else if (matID < 4.5)
    //{
    //  mate.xyz = float3(1.0,1.0,1.0)*0.5;
    //}

    return mate;
  }

#endif // _CONSTANT_WIDTH_HLSL_
